# .bash_profile

# Get the aliases and functions
if [ -f ~/.bashrc ]; then
        . ~/.bashrc
fi

# User specific environment and startup programs
PATH=$PATH:$HOME/bin 

# Base location where installs are located.
BASE_TOOLS_URL=http://vapcpappmhvcm82.tmc.va.gov/tools
export BASE_TOOLS_URL

# Directory where the software to be installed is located
SOFTWARE_DIRECTORY="/installs"
export SOFTWARE_DIRECTORY

# Base directory
BASE_DIRECTORY="/u01/app"
export BASE_DIRECTORY
 
# Directory where the JVM will be installed
JAVA_HOME="JDK_INSTALL_LOCATION"
export JAVA_HOME
 
# Directory where the configuration will be placed
CONFIGURATION_HOME="${BASE_DIRECTORY}"
export CONFIGURATION_HOME

export TOOLS_URI=http://vapcpappmhvcm82.tmc.va.gov/tools

export LIFERAY_SP=VAGRANT_LIFERAY_SP
export LIFERAY_BUILD_ID=VAGRANT_LIFERAY_BUILD_ID
export LIFERAY_BASE_VERSION=VAGRANT_LIFERAY_BASE_VERSION-${LIFERAY_SP}
export LIFERAY_VERSION=${LIFERAY_BASE_VERSION}-${LIFERAY_BUILD_ID}
export TOMCAT_VERSION=VAGRANT_TOMCAT_VERSION
export LIFERAY_WARFILE=liferay-portal-$LIFERAY_VERSION.war
export LIFERAY_TOMCAT_BUNDLE=liferay-portal-tomcat-$LIFERAY_VERSION.zip
export LIFERAY_HOME=$BASE_DIRECTORY/liferay-portal-$LIFERAY_BASE_VERSION
export LIFERAY_TOMCAT_HOME=$LIFERAY_HOME/tomcat-$TOMCAT_VERSION
export LIFERAY_FOLDER=liferay-portal-$LIFERAY_BASE_VERSION

# Update the path for the user
export PATH=$JAVA_HOME/bin:$PATH

# Create handy aliases that I like!
alias ll="ls -la" 
